10 REM basic program to generate dome.msh
20 DIM X(36),Y(36),Z(36)
30 REM FNASN(X) is arcsin function of X, X not equal to 1
40 DEF FNASN(X) = ATN(X/SQR(1-X*X))
50 REM FNACS(X) is arccos function of X, X not equal to 1
60 DEF FNACS(X) = PI#/2-FNASN(X)
70 PI# = 3.141592653#
80 REM data statements used to describe member connectivity
90 DATA  1, 2, 3, 4, 5, 6, 7, 8, 9,10, 1,0
100 DATA 11,12,13,14,15,16,17,18,19,20,11,0
110 DATA 21,22,23,24,25,26,27,28,29,30,21,0
120 DATA 31,32,33,34,35,31,0
130 DATA  1,11,21,31,36,0
140 DATA  2,12,22,32,0
150 DATA  3,13,23,32,36,0
160 DATA  4,14,24,33,0
170 DATA  5,15,25,33,36,0
180 DATA  6,16,26,34,0
190 DATA  7,17,27,34,36,0
200 DATA  8,18,28,35,0
210 DATA  9,19,29,35,36,0
220 DATA 10,20,30,31,0
230 DATA  1,20,29,0
240 DATA  2,11,30,35,0
250 DATA  3,12,21,0
260 DATA  4,13,22,31,0
270 DATA  5,14,23,0
280 DATA  6,15,24,32,0
290 DATA  7,16,25,0
300 DATA  8,17,26,33,0
310 DATA  9,18,27,0
320 DATA 10,19,28,34,0
330 DATA 0
340 REM THETAO or TH is latitude angle, PH is longitude angle
350 REM THETAO = PI#/2 - 2 * FNASN(1.051462/2)
360 REM icosahedron arc angle is 63 26' 05.808"
370 ICOSA# = (63# + (26# + 5.808#/60)/60)/180*PI#
380 REM R is circumscribed dome radius in inches
390 R = 120
400 TH = -(PI#/2 - ICOSA#)
410 FOR I =  1 TO 9 STEP 2
420     PH = (-36 +(I- 1)*36) * PI#/180
430     X(I) = R * COS(TH) * SIN(PH)
440     Y(I) = R * SIN(TH)
450     Z(I) = R * COS(TH) * COS(PH)
460 NEXT
470 FOR I =  2 TO 8 STEP 2
480     J = I+1 : GOSUB 1220
490 NEXT
500 I = 10 : J = 1 : GOSUB 1220
510 TH = 0
520 FOR I = 11 TO 20
530     PH = (-18 +(I-11)*36) * PI#/180
540     X(I) = R * COS(TH) * SIN(PH)
550     Y(I) = R * SIN(TH)
560     Z(I) = R * COS(TH) * COS(PH)
570 NEXT
580 TH = +(PI#/2 - ICOSA#)
590 FOR I = 21 TO 29 STEP 2
600     PH = (  0 +(I-21)*36) * PI#/180
610     X(I) = R * COS(TH) * SIN(PH)
620     Y(I) = R * SIN(TH)
630     Z(I) = R * COS(TH) * COS(PH)
640 NEXT
650 FOR I =  22 TO 28 STEP 2
660     J = I+1 : GOSUB 1220
670 NEXT
680 I = 30 : J = 21 : GOSUB 1220
690 TH = +(PI#/2 - ICOSA#/2)
700 FOR I = 31 TO 35
710     PH = (  0 + (I-31)*72) * PI#/180
720     X(I) = R * COS(TH) * SIN(PH)
730     Y(I) = R * SIN(TH)
740     Z(I) = R * COS(TH) * COS(PH)
750 NEXT
760     X(36) = 0
770     Y(36) = R
780     Z(36) = 0
790 OPEN "dome.msh" FOR OUTPUT AS #1
800 PRINT #1,36
810 FOR I=1 TO 10
820     PRINT #1,USING" ### ####.### ####.### ####.###";I,X(I),Y(I),Z(I);
830     PRINT #1," 0 0 0 1 1 1"
840 REM PRINT #1,USING" ####.## ";SQR(X(I)^2+Y(I)^2+Z(I)^2)
850 NEXT
860 FOR I=11 TO 36
870     PRINT #1,USING" ### ####.### ####.### ####.###";I,X(I),Y(I),Z(I);
880     PRINT #1," 1 1 1 1 1 1"
890 REM PRINT #1,USING" ####.## ";SQR(X(I)^2+Y(I)^2+Z(I)^2)
900 NEXT
910 PRINT #1,95
920 READ IB
930 IF IB = 0 THEN CLOSE : END
940 READ IE
950 IF IE = O GOTO 920
960 GOSUB 1020
970     PRINT #1,USING" ### ### # #";IB,IE,1,1;
980     PRINT #1,USING" ####.# \      \";RA,"DF2X8   "
990 REM PRINT #1,USING" ####.## ";MEMLEN
1000 IB = IE
1010 GOTO 940
1020 REM subroutine to figure roll angle (RA)
1030 REM note: there is no provision for vertical members
1040 REM A1*x + B1*y + C1*z = 0 describes local XY plane in global coordinates
1050 A1 =   Y(IE)*Z(IB) - Y(IB)*Z(IE)
1060 B1 =  -X(IE)*Z(IB) + X(IB)*Z(IE)
1070 C1 =   X(IE)*Y(IB) - X(IB)*Y(IE)
1080 REM A2*x + B2*y + C2*z = 0 describes vertical plane containing local X axis
1090 REM                                  in global coordinates
1100 A2 =  -(Z(IE)-Z(IB))
1110 B2 =   0
1120 C2 =   (X(IE)-X(IB))
1130 REM  RA is roll angle or
1140 REM angle between local XY plane and vertical plane containing local X axis
1150 ABC1 = SQR(A1*A1+B1*B1+C1*C1)
1160 ABC2 = SQR(A2*A2+B2*B2+C2*C2)
1170 COSRA = (A1*A2+B1*B2+C1*C2)/(ABC1*ABC2)
1180 IF ABS(COSRA)>.99999 THEN RA=0 ELSE RA = FNACS(COSRA) * 180/PI#
1190 IF .0005 < B1 THEN RA = RA - 180
1200 MEMLEN = SQR((X(IE)-X(IB))^2+(Y(IE)-Y(IB))^2+(Z(IE)-Z(IB))^2)
1210 RETURN
1220 REM subroutine to move midpoint of icosa-edge to surface of sphere
1230 XM = (X(I-1)+X(J))/2
1240 YM = (Y(I-1)+Y(J))/2
1250 ZM = (Z(I-1)+Z(J))/2
1260 VECLEN = SQR(XM^2+YM^2+ZM^2)
1270 X(I) = R * XM/VECLEN
1280 Y(I) = R * YM/VECLEN
1290 Z(I) = R * ZM/VECLEN
1300 RETURN
