/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class KeyLookupTable {
    public static CustomKey[] customKeys = null;

    public static int customTableLookup(int modifiers, int key) {
        if (customKeys == null) {
            return -1;
        }
        CustomKey[] customKeyArray = customKeys;
        int n = 0;
        while (n < customKeyArray.length) {
            CustomKey k = customKeyArray[n];
            if (k.key == key && k.modifiers == modifiers) {
                return k.doscode;
            }
            ++n;
        }
        return -1;
    }

    public static synchronized int readTranslationTable(String filename) throws FileNotFoundException, IOException, KeyboardTableParsingException {
        int ttype;
        int n;
        BufferedReader i = new BufferedReader(new FileReader(filename));
        StreamTokenizer st = new StreamTokenizer(i);
        Vector<CustomKey> keys = new Vector<CustomKey>();
        if (customKeys != null) {
            CustomKey[] customKeyArray = customKeys;
            n = 0;
            while (n < customKeyArray.length) {
                CustomKey c = customKeyArray[n];
                keys.add(c);
                ++n;
            }
        }
        st.slashSlashComments(true);
        st.lowerCaseMode(false);
        st.eolIsSignificant(true);
        st.parseNumbers();
        int count = 0;
        while ((ttype = st.nextToken()) != -1) {
            if (n == 10) continue;
            if (n != 34) {
                throw new KeyboardTableParsingException("key name expected", filename, st.lineno());
            }
            String name = st.sval;
            ttype = st.nextToken();
            if (ttype != -2) {
                throw new KeyboardTableParsingException("modifiers expected", filename, st.lineno());
            }
            int modifiers = (int)st.nval;
            ttype = st.nextToken();
            if (ttype != -2) {
                throw new KeyboardTableParsingException("key expected", filename, st.lineno());
            }
            int key = (int)st.nval;
            ttype = st.nextToken();
            if (ttype != -2) {
                throw new KeyboardTableParsingException("doscode expected", filename, st.lineno());
            }
            int doscode = (int)st.nval;
            ttype = st.nextToken();
            if (ttype != 10) {
                throw new KeyboardTableParsingException("End of line expected", filename, st.lineno());
            }
            CustomKey c = new CustomKey(name, modifiers, key, doscode);
            keys.add(c);
            ++count;
        }
        while (ttype != -1) {
        }
        customKeys = keys.toArray(new CustomKey[keys.size()]);
        i.close();
        return count;
    }

    public static class CustomKey {
        public String name;
        int modifiers;
        int key;
        public int doscode;

        CustomKey(String name, int modifiers, int key, int doscode) {
            this.name = name;
            this.modifiers = modifiers;
            this.key = key;
            this.doscode = doscode;
        }
    }

    public static class KeyboardTableParsingException
    extends Exception {
        String string;

        KeyboardTableParsingException(String error, String filename, int line) {
            this.string = "KeyboardTableParsingException: " + error + " in file " + filename + " line #" + line;
        }

        public String toString() {
            return this.string;
        }
    }
}

