/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosScreenVGA16
extends DosScreen {
    static int[] vga16Colors = new int[]{0, 128, 32768, 32896, 0x800000, 0x800080, 0x808000, 0xC0C0C0, 0x808080, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF};
    private String name;
    private BufferedImage bufferedImage;
    public int signatureSize;
    final int sizeX;
    final int sizeY;
    final int bitplanes;
    final int slices;
    final int sliceSize;
    boolean[][][] pixelBuffer;
    int[][] rgbBuffer;
    int viewRequestCode;
    int lastBitPlane = 255;
    int lastSlice = 255;

    @Override
    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DosScreenVGA16(int width, int height, int bitplanes, int slices, int viewRequestCode) {
        this.sizeX = width;
        this.sizeY = height;
        this.bitplanes = bitplanes;
        this.slices = slices;
        this.sliceSize = this.sizeX * this.sizeY / 8 / slices;
        this.viewRequestCode = viewRequestCode;
        this.pixelBuffer = new boolean[width][height][bitplanes];
        this.rgbBuffer = new int[width][height];
        this.bufferedImage = new BufferedImage(this.sizeX, this.sizeY, 1);
        this.name = new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("VGA ").append(width).toString()).append("x").toString()).append(height).toString()).append("x").toString()).append(bitplanes).toString()).append("/").toString()).append(slices).toString();
        this.signatureSize = height * width / 8 / slices + 2;
    }

    private void setPixelRGB(int x, int y) {
        int rgb = 0;
        int bitplane = 0;
        while (bitplane < this.bitplanes) {
            rgb >>= 1;
            if (this.pixelBuffer[x][y][bitplane]) {
                rgb |= 8;
            }
            ++bitplane;
        }
        this.rgbBuffer[x][y] = vga16Colors[rgb];
    }

    private void updateBufferedImage() {
        BufferedImage bufferedImage = this.bufferedImage;
        synchronized (bufferedImage) {
            int x = 0;
            while (x < this.sizeX) {
                int y = 0;
                while (y < this.sizeY) {
                    this.bufferedImage.setRGB(x, y, this.rgbBuffer[x][y]);
                    ++y;
                }
                ++x;
            }
        }
    }

    @Override
    public int getLastBitPlane() {
        return this.lastBitPlane;
    }

    @Override
    public int getLastSlice() {
        return this.lastSlice;
    }

    @Override
    public boolean update(byte[] data, int len) {
        int bitplane = data[this.sliceSize + 0] & 0xFF;
        int slice = data[this.sliceSize + 1] & 0xFF;
        if (bitplane >= this.bitplanes || slice >= this.slices) {
            System.out.println(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Recieved a corrupted frame: slice=").append(slice).toString()).append(" bitplane=").toString()).append(bitplane).toString()).append(" [").toString()).append(this.name).toString()).append("]").toString());
            return false;
        }
        this.lastBitPlane = bitplane;
        this.lastSlice = slice;
        boolean changed = false;
        int bytesPerLine = this.sizeX / 8;
        int linesPerSlice = this.sliceSize / bytesPerLine;
        int y = slice * linesPerSlice;
        int x = (this.sliceSize * slice - y * bytesPerLine) * 8;
        int i = 0;
        while (i < this.sliceSize) {
            int b = data[i];
            int j = 0;
            while (j < 8) {
                boolean pixel;
                boolean bl = pixel = (b & 0x80) == 128;
                if (!this.pixelBuffer[x][y][bitplane] ? pixel : !pixel) {
                    this.pixelBuffer[x][y][bitplane] = pixel;
                    this.setPixelRGB(x, y);
                    changed = true;
                }
                b <<= 1;
                if (++x >= this.sizeX) {
                    x = 0;
                    ++y;
                }
                ++j;
            }
            ++i;
        }
        if (changed) {
            this.updateBufferedImage();
            return true;
        }
        return false;
    }

    @Override
    public int getSignatureDataLength() {
        return this.signatureSize;
    }

    void addScanSystems(ScreenRequestSenderList.ScreenRequestSenderNodeBranch node, int mode) {
        node.addLeaf("Progressive", new ScreenRequestSender(87, mode, 0, 0));
        node.addLeaf("Interlaced", new ScreenRequestSender(87, mode, 1, 0));
    }

    @Override
    void addScreenRequestSenders(ScreenRequestSenderList.ScreenRequestSenderNodeBranch node) {
        ScreenRequestSenderList.ScreenRequestSenderNodeBranch subNode = node.addBranch(this.name);
        this.addScanSystems(subNode, this.viewRequestCode);
    }
}

