/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosScreenText
extends DosScreen {
    private String name;
    private BufferedImage bufferedImage;
    public int signatureSize;
    final int screenHeightchars;
    final int screenWidthChars;
    final byte[] onScreenBuffer;
    int onScreenCursorX;
    int onScreenCursorY;
    static final int charHeight = VgaSoftFont.height;
    static final int charWidth = VgaSoftFont.width;
    final int bufferHeight;
    final int bufferWidth;
    int[] bufferArray;
    int requestMode;
    int pages;
    boolean cursorBlink = true;

    @Override
    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DosScreenText(int width, int height, int requestMode, int pages) {
        this.screenHeightchars = height;
        this.screenWidthChars = width;
        this.bufferWidth = charWidth * this.screenWidthChars;
        this.bufferHeight = charHeight * this.screenHeightchars;
        this.onScreenBuffer = new byte[this.screenHeightchars * this.screenWidthChars * 2];
        this.bufferedImage = new BufferedImage(this.bufferWidth, this.bufferHeight, 1);
        this.bufferArray = new int[this.bufferWidth * this.bufferHeight];
        this.name = new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Text ").append(width).toString()).append("x").toString()).append(height).toString();
        this.signatureSize = height * width * 2 + 4;
        this.requestMode = requestMode;
        this.pages = pages;
    }

    @Override
    public boolean update(byte[] data, int len) {
        int cursorX = data[this.screenHeightchars * this.screenWidthChars * 2 + 0] & 0xFF;
        int cursorY = data[this.screenHeightchars * this.screenWidthChars * 2 + 1] & 0xFF;
        int cursorT = data[this.screenHeightchars * this.screenWidthChars * 2 + 2] & 0xFF;
        int cursorB = data[this.screenHeightchars * this.screenWidthChars * 2 + 3] & 0xFF;
        int y = 0;
        while (y < this.screenHeightchars) {
            int x = 0;
            while (x < this.screenWidthChars) {
                int index = (y * this.screenWidthChars + x) * 2;
                byte displayChar = data[index];
                byte displayColor = data[index + 1];
                byte onScreenChar = this.onScreenBuffer[index];
                byte onScreenColor = this.onScreenBuffer[index + 1];
                if (displayChar != onScreenChar || displayColor != onScreenColor || x == this.onScreenCursorX && y == this.onScreenCursorY) {
                    boolean[][] m = VgaSoftFont.pixels[displayChar & 0xFF];
                    int onColor = VgaSoftFont.colors[displayColor & 0xF];
                    int offColor = VgaSoftFont.colors[(displayColor & 0xF0) >> 4];
                    int dest = y * charHeight * (this.screenWidthChars * charWidth) + x * charWidth;
                    int l = 0;
                    while (l < charHeight) {
                        boolean[] scanline = m[l];
                        int p = 0;
                        while (p < charWidth) {
                            this.bufferArray[dest++] = scanline[p] ? onColor : offColor;
                            ++p;
                        }
                        dest += (this.screenWidthChars - 1) * charWidth;
                        ++l;
                    }
                    this.onScreenBuffer[index] = displayChar;
                    this.onScreenBuffer[index + 1] = displayColor;
                }
                ++x;
            }
            ++y;
        }
        if (this.cursorBlink) {
            if (cursorX < this.screenWidthChars && cursorY < this.screenHeightchars) {
                int l = cursorT;
                while (l <= cursorB) {
                    int dest = cursorY * charHeight * (this.screenWidthChars * charWidth) + cursorX * charWidth + l * charWidth * this.screenWidthChars;
                    int p = 0;
                    while (p < charWidth) {
                        this.bufferArray[dest] = 0xFFFFFF;
                        ++dest;
                        ++p;
                    }
                    ++l;
                }
            }
            this.onScreenCursorX = cursorX;
            this.onScreenCursorY = cursorY;
            this.cursorBlink = false;
        } else {
            this.cursorBlink = true;
        }
        BufferedImage bufferedImage = this.bufferedImage;
        synchronized (bufferedImage) {
            this.bufferedImage.setRGB(0, 0, this.bufferWidth, this.bufferHeight, this.bufferArray, 0, this.bufferWidth);
        }
        return true;
    }

    @Override
    public int getSignatureDataLength() {
        return this.signatureSize;
    }

    void addPages(ScreenRequestSenderList.ScreenRequestSenderNodeBranch node, int mode, int a1) {
        int p = 0;
        while (p < this.pages) {
            node.addLeaf(new StringBuffer().append("Page ").append(p).toString(), new ScreenRequestSender(87, mode, a1, p));
            ++p;
        }
    }

    @Override
    public int getLastBitPlane() {
        return 0;
    }

    @Override
    public int getLastSlice() {
        return 0;
    }

    @Override
    void addScreenRequestSenders(ScreenRequestSenderList.ScreenRequestSenderNodeBranch node) {
        ScreenRequestSenderList.ScreenRequestSenderNodeBranch subNode = node.addBranch(this.name);
        ScreenRequestSenderList.ScreenRequestSenderNodeBranch colorNode = subNode.addBranch("Color (B800)");
        this.addPages(colorNode, this.requestMode, 0);
        ScreenRequestSenderList.ScreenRequestSenderNodeBranch monoNode = subNode.addBranch("Mono (B000)");
        this.addPages(monoNode, this.requestMode, 1);
    }
}

